import numpy as np
import Const
import re

"""Q値クラス
"""
class Qtable:
    def __init__(self):
        self.table = {} #Q値テーブル

    def update(self,key,act):   #デバック用 Q値テーブルを1行作成
        if key in self.table:
            self.table[key] = act
        else:
            self.table[key] = act

    def  get(self,key):         #状態情報から全Q値を取得
        if key not in self.table.keys():    #Q値がなかったら新規作成
            act = np.zeros((Const.BANSU,Const.BANSU))
            """状態により不要なQ値(状態により既に手が打たれているマス目がある、このQ値(行動)は打てないので不要）
            　　が影響を及ぼさないように最小値を設定
                ○×○
                × ×  -> 状態：212101012　-> 2,1に該当するQ値不要->最小値設定
                 ×○
            """            
            work = str(Const.BATU)+'|'+str(Const.MARU)
            m = re.search(work, key)
            a = [m.start() for m in re.finditer(work, key)] #状態情報から既に打たれている箇所を検索
            for idx in a:
                q, mod = divmod(idx, Const.BANSU)
                act[q][mod] = Const.MIN＿VALUE
            self.table[key] = act

        return self.table[key]

    def disp(self): #状態：Q値全表示
        for key, values in self.table.items():
            moji = ""
            for value in values:
                moji += str(value)
            print("key:" + key + "values:" + moji)
            

    def getMaxTable(self,key):  #状態の最大Q値を取得
        data = self.get(key)
        return np.nanmax(data)
    
    def cal(self,key1,key2,x,y,win):    #Q値更新
        data = self.get(key1) #Q値取得
        if key2 != 0:   #次の手有り
            data[x][y] = data[x][y] + Const.GAKUSYU*(win+Const.WARIBIKI*(self.getMaxTable(key2))-data[x][y]) 
        else:   #勝敗がついた場合は次の手の最大値の取得は不要
            data[x][y] = data[x][y] + Const.GAKUSYU*(win-data[x][y]) 

        self.table[key1] = data



